/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.OvRemoteTrapListenerInterface;
import ibm.nways.jdm.OvTrapHandlerInterface;
import ibm.nways.jdm.OvTrapListenerInterface;
import ibm.nways.jdm.snmp.SnmpTrap;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class OvTrapHandlerClient
implements OvRemoteTrapListenerInterface,
Serializable {
    private OvTrapHandlerInterface trapHandler;
    private boolean initialized = false;
    private boolean registeredForUpdates = false;
    private OvTrapListenerInterface updatesListener;

    public boolean init(String string) {
        System.out.println("OvTrapHandlerClient.init: exporting remote object");
        try {
            UnicastRemoteObject.exportObject(this);
        }
        catch (RemoteException remoteException) {
            System.out.println("OvTrapHandlerClient exportObjectException, snmptrap reception won't work");
            remoteException.printStackTrace();
        }
        Integer n = new Integer(2099);
        try {
            String string2 = n.toString();
            System.out.println("@@@@OvTrapHandler Client Port number: " + string2);
            if (string == null) {
                string = InetAddress.getLocalHost().getHostName();
            }
            this.trapHandler = (OvTrapHandlerInterface)Naming.lookup("//" + string + ":" + string2 + "/OvTrapHandler");
            System.out.println("@@@@OvTrapHandler version: " + this.trapHandler.getVersion());
        }
        catch (Exception exception) {
            System.out.println("@@@@OvTrapHandlerClient RMI exception:");
            exception.printStackTrace();
            return false;
        }
        this.initialized = true;
        return this.initialized;
    }

    public void startTrapHandler() {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.trapHandler.startTrapHandler();
            return;
        }
        catch (Exception exception) {
            System.out.println("trapHandler DB AccessException:");
            exception.printStackTrace();
            return;
        }
    }

    public void stopTrapHandler() {
        if (!this.initialized) {
            this.init(null);
        }
        try {
            this.trapHandler.stopTrapHandler();
            return;
        }
        catch (Exception exception) {
            System.out.println("trapHandler DB AccessException:");
            exception.printStackTrace();
            return;
        }
    }

    public boolean registerForTraps(OvTrapListenerInterface ovTrapListenerInterface) {
        if (!this.initialized) {
            this.init(null);
        }
        System.out.println("OvTrapHandler::registerForTraps!");
        boolean bl = false;
        try {
            if (ovTrapListenerInterface != null) {
                System.out.println("^OvTrapHandler::registerForTraps reging with server!");
                bl = this.trapHandler.registerForTraps(this);
                System.out.println("^OvTrapHandler::registerForTraps reg with server SUCCESS!");
                this.updatesListener = ovTrapListenerInterface;
                this.registeredForUpdates = true;
            } else {
                System.out.println("OvTrapHandler::registerForTraps Null reference for listener!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean deregisterForTraps(OvTrapListenerInterface ovTrapListenerInterface) {
        if (!this.initialized) {
            this.init(null);
        }
        boolean bl = false;
        try {
            if (this.registeredForUpdates && this.updatesListener == ovTrapListenerInterface) {
                bl = this.trapHandler.deregisterForTraps(this);
                this.updatesListener = null;
                this.registeredForUpdates = false;
            } else {
                System.out.println("OvTrapHandler::deregisterForTraps incorrect reference passed!" + ovTrapListenerInterface);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public boolean trapReceived(SnmpTrap snmpTrap) {
        System.out.println("* OvTrapHandlerClient Trap Received " + snmpTrap);
        if (this.registeredForUpdates) {
            this.updatesListener.trapReceived(snmpTrap);
        }
        return true;
    }
}

